<?php
/**
 * The template for displaying Design Center
 *
 * Template Name: Design Center
 *
 * @package Luxx
 */

get_header(); ?>
<?php while (have_posts()) : the_post(); ?>
	<section class="parallax-container valign-wrapper banner-single">
	    <div class="parallax"><img src="<?php echo get_field('banner')['url'] ?>"></div>
	    <a id="scrollto" href="#"><i class="luxx-chevron-thin-down"></i></a>
	</section>

	<section>
	    <div class="container-50">
	        <div class="row">
	            <div class="col s12 l5">
	                <h2 class="title-2">Luxx Newhouse Design Centre</h2>
	                <h3 class="title-3"><?php echo get_field('centre_title') ?></h3>
	            </div>
	            <div class="col s12 l7">
	                <p><?php echo get_field('centre_description') ?></p>
	            </div>
	        </div>
	    </div>
	</section>

	        <section class="parallax-container" style="padding-top: 0;">
	            <div class="parallax" style="height: 50vh; top: auto;"><img src="<?php echo get_field('background')['url'] ?>"></div>
	            <div class="container-50">
	                <div class="row">
	                    <div class="col s12">
	                        <div class="gallery-slider-wrapper">
	                            <div id="gallery-carousel-1" class="owl-carousel gallery-carousel">
	                            	<?php $slides = get_field('slider') ?>
	                            	<?php foreach ($slides as $slide): ?>
	                                <div class="item">
	                                    <img src="<?php echo $slide['slider_image']['url'] ?>" class="responsive-img full-width">
	                                </div>
	                            	<?php endforeach; ?>
	                            </div>
	                            <div class="container-50 carousel-status gallery-carousel-status">
	                                <span class="owl-current"></span>of<span class="owl-total"></span>
	                            </div>
	                        </div>
	                    </div>
	                </div>
	                <br>
	                <br>
	                <br>
	                <div class="row center-align">
	                    <div class="col s12 l8 offset-l2">
	                        <h3 class="title-3"><?php echo get_field('lab_title') ?></h3>
	                        <p><?php echo get_field('lab_desc') ?></p>
	                        <a href="/contact/enquiry" class="btn btn-nobg"><?php echo get_field('button_caption') ?></a>
	                    </div>
	                </div>
	            </div>
	        </section>
<?php endwhile; ?>
<?php get_footer(); ?>
