<?php
/**
 * The template for displaying Home page
 *
 * Template Name: Home
 *
 * @package Luxx
 */
get_header(); ?>
<?php while (have_posts()) : the_post(); ?>
	<div class="home-banner">
	    <div class="hero-wrapper">
	        <!--<div class="hero-bg"></div>-->
	        <div class="hero">
	            <img class="hero-img responsive-img" src="<?php echo get_template_directory_uri() . '/img/hero-logo.png' ?>">
	        </div>
	    </div>
	    <div id="home-carousel-1" class="owl-carousel home-carousel">
	    	<?php $sliders = get_field('slider'); ?>
	    	<?php foreach ($sliders as $slider): ?>
	    	<div class="item valign-wrapper" style="background-image: url('<?php echo $slider['slide_image']['url'] ?>')">
	            <div class="animated valign">
	                <h1 class="title-1 center-align"><?php echo $slider['slide_title'] ?></h1>
	            </div>
				<div class="image-credit">
					<p>
						<?php echo get_featured_image_copyright($slider['slide_image']['ID']) ?>
					</p>
				</div>
	        </div>
	    	<?php endforeach; ?>
	    </div>

	    <!-- Home menu -->
	    <div class="navbar-home hide-on-med-and-down">
	        <nav>
	            <div class="nav-wrapper">
	                <ul>
	                    <li><a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="brand active"><i class="luxx-home"></i></a></li>
	                </ul>
	                <?php
	                	/**
	                	* Displays a language menu.
	                	*
	                	* @since 3.0.0
	                	*/
	                	$lang_walker =  new Home_Lang_Nav_Menu();
	                	$lang_defaults = array(
	                		'theme_location' => 'language-switcher',
	                		'menu' => 'language-switcher',
	                		'menu_class' => 'right hide-on-med-and-down language',
	                		'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
	                		'walker' => $lang_walker,
	                	);
	                	wp_nav_menu($lang_defaults);

	                   /**
	                	* Displays a navigation menu.
	                	*
	                	* @since 3.0.0
	                	*/
	                	$walker = new Home_Main_Nav_Menu();
	                	$defaults = array(
	                		'theme_location' => 'primary-menu',
	                		'menu' => 'main-menu',
	                		'menu_class' => 'menu',
	                		'menu_id' => 'menuHome',
	                		'echo' => true,
	                		'fallback_cb' => 'wp_page_menu',
	                		'before' => '',
	                		'after' => '',
	                		'link_before' => '',
	                		'link_after' => '',
	                		'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
	                		'depth' => 0,
	                		'walker' => $walker
	                	);

	                	wp_nav_menu( $defaults );
	                 ?>
	            </div>
	        </nav>
	    </div>
	</div>

	<section>
		<?php
		$about_sub_title = get_field('about_us_-_sub_title');
		$about_title = get_field('about_us_-_title');
		$about_desc = get_field('about_us_-_description');
		$about_img = get_field('about_us_-_image');
		$about_link = get_field('about_us_-_linked_page');
		?>
	    <div class="container-50">
	        <div class="row valign-wrapper">
	            <div class="col s12 m6 l7 valign">
	                <img src="<?php echo $about_img['url'] ?>" class="responsive-img full-width" alt="<?php echo $about_title ?>">
					<div class="image-credit">
						<p>
							<?php echo get_featured_image_copyright($about_img['ID']) ?>
						</p>
					</div>
	            </div>
	            <div class="col s12 m6 l5 valign">
	                <h2 class="title-2"><?php echo $about_sub_title ?></h2>
	                <h3 class="title-3"><?php echo $about_title ?></h3>
	                <p><?php echo $about_desc ?></p>
	                <a class="more-btn" href="<?php echo $about_link ?>"><i class="luxx-long-arrow-right"></i></a>
	            </div>
	        </div>
	    </div>
	</section>

	<section class="parallax-container valign-wrapper" style="background: none;">
		<?php
		$center_title = get_field('newhouse_design_center_-_title');
		$center_desc = get_field('newhouse_design_center_-_description');
		$center_img = get_field('newhouse_design_center_-_image');
		$center_link = get_field('newhouse_design_center_-_linked_page');
		$center_btn_text = get_field('newhouse_design_center_button_text');
		$center_subtitle = get_field('newhouse_design_centre_-_subtitle');
		$product_img = get_field('products_&_services_-_image');
		?>

	    <div class="parallax"><img src="<?php echo $center_img['url'] ?>"></div>
	    <div class="container-50 valign center-align">
	        <div class="row">
	            <div class="col s12 l8 offset-l2">
	                <h2 class="title-2"><?php echo $center_subtitle ?></h2>
	                <h1 class="title-1"><?php echo $center_title ?></h1>
	                <p><?php echo $center_desc ?></p>
	                <p>
	                    <a class="btn btn-nobg" href="<?php echo $center_link ?>"><?php echo $center_btn_text ?></a>
	                </p>
	            </div>
	        </div>
	    </div>
	</section>
	<div style="background: #FFF;">
		<div class="image-credit" style="margin-left: 40px; margin-bottom: 0; margin-top: -10px; padding: 1px 0;">
			<p><?php echo get_featured_image_copyright($center_img['ID']) ?></p>
		</div>
	</div>

	<section>
		<?php
		$product_title = get_field('products_&_services_-_title');
		$product_desc = get_field('products_&_services_-_description');
		$product_img = get_field('products_&_services_-_image');
		$product_link = get_field('products_&_services_-_linked_page');

		$gallery_title = get_field('gallery_title');
		$gallery_desc = get_field('gallery_desc');
		$gallery_img = get_field('gallery_-_image');
		$gallery_link = get_field('gallery_-_linked_page');
		?>
	    <div class="container-50">
	        <div class="row">
	            <div class="col s12 m6 luxx_card">
	                <img src="<?php echo $product_img['url'] ?>" class="responsive-img full-width" alt="Image">
					<div class="image-credit">
						<p><?php echo get_featured_image_copyright($product_img['ID']) ?></p>
					</div>
	                <h3 class="title-3"><?php echo $product_title ?></h3>
	                <div class="wrap">
	                    <?php echo $product_desc ?>
	                    <a class="more-btn" href="<?php echo $product_link ?>"><i class="luxx-long-arrow-right"></i></a>
	                </div>
	            </div>
	            <div class="col s12 m6 luxx_card">
	                <img src="<?php echo $gallery_img['url'] ?>" class="responsive-img full-width" alt="Image">
					<div class="image-credit">
						<p><?php echo get_featured_image_copyright($gallery_img['ID']) ?></p>
					</div>
	                <h3 class="title-3"><?php echo $gallery_title ?></h3>
	                <div class="wrap">
	                    <?php echo $gallery_desc ?>
	                    <a class="more-btn" href="<?php echo $gallery_link ?>"><i class="luxx-long-arrow-right"></i></a>
	                </div>
	            </div>
	        </div>
	    </div>
	</section>

	<section class="hide">
	    <div class="container-50">
	        <h1 class="title-1">Contemporary Living <br>Seamless Solutions</h1>
	        <h2 class="title-2">About Us</h2>
	        <h3 class="title-3">Luxx Newhouse Group</h3>
	        <a href="#">More</a>
	        <p class="quote">Innovation is at the heart of what we do, and we are always thinking ahead. The Luxx Newhouse Design Centre the first of its kind – a home to the newest solid surface technologies and a showcase of our capabilities in design.</p>
	    </div>
	</section>
<?php endwhile; ?>
<?php get_sidebar(); ?>
<?php get_footer(); ?>
