<?php
/**
 * The template for displaying Country Product
 *
 * Template Name: Country
 *
 * @package Luxx
 */

get_header(); ?>
<?php while (have_posts()) : the_post(); ?>
	<?php
	$products = get_field('products_list');
	?>
	<section style="padding: 0; margin-top: -40px;">
	    <div class="container-50">
	        <div class="row hide-on-small-only">
	            <div class="col s12">
	                <ul class="tabs brands-tabs">
	                	<?php if (count($products) > 0): ?>
	                		<?php foreach ($products as $key => $post): setup_postdata($post) ?>
	                    	<li class="tab col s12 m4">
	                    		<a class="<?php echo ($key == 0 ? 'active' : '') ?>" href="#" data-slide-index="<?php echo $key ?>">
	                    			<h4 class="title-3"><?php the_title() ?></h4><span><?php echo get_field('product_category') ?></span>
	                    		</a>
	                    	</li>
	                    	<?php endforeach ?>
	                	<?php endif ?>
	                </ul>
	            </div>
	        </div>
	        <div class="row hide-on-med-and-up" style="margin: 40px 0 30px;">
	            <div class="col s12 select-box">
	            	<?php if (count($products) > 0): ?>
	            		<a class="dropdown-button-click" href="#!" data-activates="category_select">
	            			<h4 class="title-3"><?php echo apply_filters( 'the_title', $products[0]->post_title ) ?></h4> <i class="luxx-chevron-down"></i><br><span><?php echo get_field('product_category', $products[0]->ID) ?></span>
	            		</a>
	            		<ul id="category_select" class="dropdown-content brands_select">
	                		<?php foreach ($products as $key => $post): setup_postdata($post) ?>
	                    		<li><a href="#!" data-value="<?php the_title() ?>" data-span="<?php echo get_field('product_category') ?>" data-slide-index="<?php echo $key ?>"><?php the_title() ?></a></li>
	                    	<?php endforeach ?>
                    	</ul>
                	<?php endif ?>
	            </div>
	        </div>
	    </div>
	</section>

	<section style="padding-top: 0; overflow: hidden;">
	    <div class="container-50">
	        <div class="brands-slider-wrapper">
	            <div id="brands-carousel" class="owl-carousel brands-carousel">
	            	<?php if (count($products) > 0): ?>
	            		<?php foreach ($products as $key => $post): setup_postdata($post) ?>
		                <div class="item">
		                    <div class="row" style="margin-bottom: 40px; position:relative;">
		                        <div class="col s12">
		                            <?php $p_img_1 = get_field('product_image_1'); ?>
		                            <?php if (isset($p_img_1)): ?>
		                            <img src="<?php echo $p_img_1['url'] ?>" class="responsive-img full-width">
		                            <?php endif ?>

									<?php $credit = get_featured_image_copyright($p_img_1['ID']); ?>
									<?php if ($credit !== ''): ?>
									<div class="overlay-image-credit">
										<p>
											<?php echo get_featured_image_copyright($p_img_1['ID']) ?>
										</p>
									</div>
									<?php endif ?>
		                        </div>
		                    </div>
		                    <div class="row valign-wrapper">
		                        <div class="col s12 m6 valign">
		                            <h3 class="title-3"><?php echo get_field('product_subtitle') ?></h3>
		                            <p><?php echo get_field('product_description') ?></p>

		                            <div class="row btn-list">
		                                <div class="col s12 l6">
		                                	<!-- get specs file based on the country -->
		                                	<?php
		                                	$url = get_current_page_url();
		                                	$request_url = parse_url($url, PHP_URL_PATH);
		                                	$segments = explode('/', $request_url);
		                                	$specs = get_field('pdf_file_en');
		                                	if (isset($segments[1])) {
		                                		if ($segments[1] == 'zh') {
		                                			$specs = get_field('pdf_file_zh');
		                                		} elseif ($segments[1] == 'tw') {
		                                			$specs = get_field('pdf_file_tw');
		                                		}
		                                	}
		                                	 ?>
		                                    <a target="_blank" href="<?php echo (isset($specs['url'])) ? $specs['url'] : '#' ?>" class="btn btn-full"><?php echo get_field('product_button_1_caption') ?></a>
		                                </div>
		                                <div class="col s12 l6">
		                                	<?php
		                                	$page = get_page_by_path("color-chart");
		                                	$link = get_permalink($page->ID);
		                                	$link = add_query_arg(array('product-id' => $post->ID), $link);
		                                	$button_label = get_field('product_button_2_caption');
		                                	if ($post->post_title == 'Blanco') {
		                                		$button_label = get_field('product_button_3_caption');
		                                	}
		                                	?>
		                                    <a href="<?php echo $link ?>" class="btn btn-full"><?php echo $button_label ?></a>
		                                </div>
		                            </div>
		                        </div>
		                        <div class="col s12 m6 valign">
		                            <?php $p_img_2 = get_field('product_image_2'); ?>
		                            <?php if (isset($p_img_2)): ?>
		                            <img src="<?php echo $p_img_2['url'] ?>" class="responsive-img full-width">
		                            <?php endif ?>
		                        </div>
		                    </div>
		                </div>
	                	<?php endforeach ?>
	            	<?php endif ?>
	            </div>
	        </div>
	    </div>
	</section>
<?php endwhile; ?>
<?php get_footer(); ?>
