<?php
/**
 * The template for displaying archive pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Luxx
 */

get_header(); ?>

    <section>
        <div class="container-50">

		<?php if ( have_posts() ) : ?>

			<header class="page-header">
				<?php
					the_archive_title( '<h5 class="page-title">', '</h5>' );
					the_archive_description( '<div class="taxonomy-description">', '</div>' );
				?>
			</header><!-- .page-header -->

			<?php /* Start the Loop */ ?>
			<?php while ( have_posts() ) : the_post(); ?>
                <div class="row news-wrapper">
		            <div class="col s12 m6 l6 news-slider-wrapper">
		                <div id="news-carousel-<?php the_ID() ?>" class="owl-carousel news-carousel">
		                	<?php $images = get_field('image_slider'); ?>
		                	<?php if (count($images) > 0): ?>
			                	<?php foreach ($images as $img): ?>
			                    <div class="item">
			                        <img src="<?php echo $img['image']['url'] ?>" class="responsive-img full-width">
                                    <div class="image-credit">
    									<p>
    										<?php echo get_featured_image_copyright($img['image']['ID']) ?>
    									</p>
    								</div>
			                    </div>
			                	<?php endforeach ?>
		                	<?php endif ?>
		                </div>
		            </div>
		            <div class="col s12 m6 l6 news-text">
		                <h3 class="title-3"><?php the_title() ?></h3>
		                <p><?php the_content() ?></p>

		                <div class="news-text-footer row">
		                    <div class="col s6 left-align">
		                        Posted on - <?php echo get_the_date(); ?>
		                    </div>
		                    <div class="col s6 right-align">
		                        <?php the_tags() ?>
		                    </div>
		                </div>
		            </div>
		        </div>
		        <div class="row">
		            <div class="col s12">
		                <div class="divider"></div>
		            </div>
		        </div>
			<?php endwhile; ?>

			<?php the_posts_navigation(); ?>

		<?php else : ?>

			<?php get_template_part( 'template-parts/content', 'none' ); ?>

		<?php endif; ?>

        </div><!-- #main -->
	</section><!-- #primary -->

<?php get_sidebar(); ?>
<?php get_footer(); ?>
