<?php
/**
 * The template for displaying Newsroom
 *
 * Template Name: Newsroom
 *
 * @package Luxx
 */
get_header(); ?>
<?php while (have_posts()) : the_post(); ?>
	<section style="padding-top: 40px">
	    <div class="container-50">
	    	<?php
	    	// get list of products belong to this family
	    	$args = array(
	    	    'numberposts'   => -1,
	    	    'category_name'     => 'news',
	    	    'order'         => 'ASC',
	    	    'orderby'       => 'menu_order',
	    	);
	    	$news = get_posts($args);
	    	foreach ($news as $post): setup_postdata( $post ) ?>
		        <div class="row news-wrapper">
		            <div class="col s12 m6 l6 news-slider-wrapper">
		                <div id="news-carousel-<?php the_ID() ?>" class="owl-carousel news-carousel">
		                	<?php $images = get_field('image_slider'); ?>
		                	<?php if (count($images) > 0): ?>
			                	<?php foreach ($images as $img): ?>
			                    <div class="item">
			                        <img src="<?php echo $img['image']['url'] ?>" class="responsive-img full-width">
									<?php $credit = get_featured_image_copyright($img['image']['ID']); ?>
									<?php if (trim($credit) !== ''): ?>
									<div class="overlay-image-credit" style="left:0;">
										<p>
											<p><?php echo get_featured_image_copyright($img['image']['ID']) ?></p>
										</p>
									</div>
									<?php endif ?>
			                    </div>
			                	<?php endforeach ?>
		                	<?php endif ?>
		                </div>
		            </div>
		            <div class="col s12 m6 l6 news-text">
		                <h3 class="title-3"><?php the_title() ?></h3>
		                <p><?php the_content() ?></p>

		                <div class="news-text-footer row">
		                    <div class="col s6 left-align">
		                        Posted on - <?php echo get_the_date(); ?>
		                    </div>
		                    <div class="col s6 right-align">
		                        <?php the_tags() ?>
		                    </div>
		                </div>
		            </div>
		        </div>
		        <div class="row">
		            <div class="col s12">
		                <div class="divider"></div>
		            </div>
		        </div>
		    <?php endforeach;
		    wp_reset_postdata(); ?>
	    </div>
	 </section>
<?php endwhile; ?>
<?php get_footer(); ?>
