<?php
/**
 * The template for displaying Color Chart
 *
 * Template Name: Color Chart
 *
 * @package Luxx
 */

get_header();

// pagination
if (get_query_var('page')) {
 	$page = get_query_var('page');
} else {
  	$page = 1;
}

$product_id = get_query_var('product-id', FALSE);
$category_id = get_query_var('category-id', FALSE);
$show_dropdown = TRUE;

if ($product_id) {
	// get list of color categories IDs
	$categories = get_field('color_categories', $product_id);
	$ids = wp_list_pluck( $categories, 'ID');
	$product_title = get_the_title( $product_id );
	
	// get colors
	$cat_list = array();
	if (count($ids > 0)) {
		if ($category_id) {
			$cat_list[] = get_post($category_id);
			$all_cat = FALSE;
		} else {
			// display all categories
			$cat_list = $categories;
			$all_cat = TRUE;
		}

		$total_colors = array();
		foreach ($cat_list as $cat) {
			$colors = get_field('colors', $cat->ID);
			foreach ($colors as $color) {
				$total_colors[] = $color;
			}
		}
	}
	
	if (count($ids) < 2) {
		$show_dropdown = FALSE;
	}
}

$page = get_page_by_path("color-chart");
$page_link = get_permalink($page->ID);

wp_reset_postdata();
?>
<?php while (have_posts()) : the_post(); ?>
<section>
   <div class="container-50">
       	<div class="row" style="margin-bottom: 30px;">
           <div class="col s12 m6 select-box brand-cat">
               	<h4 class="brand-name"><?php echo $product_title ?></h4>
				<?php if ($show_dropdown): ?>
					<?php if ($all_cat): ?>
						<a class="dropdown-button-click" href="#!" data-activates="category_select"><span><?php echo get_field('select_all') ?></span> <i class="luxx-chevron-down"></i></a>
					<?php else: ?>
						<a class="dropdown-button-click" href="#!" data-activates="category_select"><span><?php echo apply_filters( 'the_title', $cat_list[0]->post_title ) ?></span> <i class="luxx-chevron-down"></i></a>
					<?php endif; ?>

					<ul id="category_select" class="dropdown-content">
						<!-- Get all color categories for this product -->
						<?php foreach ($categories as $cat): ?>
							<?php $link = add_query_arg(array('product-id' => $product_id, 'category-id' => $cat->ID), $page_link);?>
							<li><a href="<?php echo $link ?>"><?php echo apply_filters( 'the_title', $cat->post_title ) ?></a></li>
						<?php endforeach ?>
						<?php $all_link = add_query_arg(array('product-id' => $product_id), $page_link);?>
						<li><a href="<?php echo $all_link ?>"><?php echo get_field('select_all') ?></a></li>
				   </ul>
				<?php endif; ?>

           	</div>
           	<div class="col s12 m6">
              <?php
              $url = get_current_page_url();
              $request_url = parse_url($url, PHP_URL_PATH);
              $segments = explode('/', $request_url);
              $specs = get_field('pdf_file_en', $product_id);
              if (isset($segments[1])) {
                if ($segments[1] == 'zh') {
                  $specs = get_field('pdf_file_zh',$product_id);
                } elseif ($segments[1] == 'tw') {
                  $specs = get_field('pdf_file_tw',$product_id);
                }
              }
               ?>

               	<a target="_blank" href="<?php echo (isset($specs['url'])) ? $specs['url'] : '#' ?>" class="btn right"><?php echo get_field('product_specs_caption') ?></a>
           	</div>
       	</div>

       	<!-- displaying colors of current category -->
       	<div class="row category show">
			<?php
			// Variables
			$row              = 0;
			$color_per_page   = 60;
			$total            = count($total_colors);
			$pages            = ceil($total / $color_per_page);
			$min              = (($page * $color_per_page) - $color_per_page) + 1;
			$max              = ($min + $color_per_page) - 1;
			?>

	       	<?php if ($total > 0): ?>
	       		<?php foreach ($total_colors as $key => $color): ?>
	       			<?php
	       			$row++;  // Ignore this color if $row is lower than $min
    				if ($row < $min) { continue; }
    				// Stop loop completely if $row is higher than $max
    				if ($row > $max) { break; }
    				?>
		       		<div class="col s12 m3">
			           	<div class="color-box" style="background-image: url(<?php echo $color['color_image']['sizes']['medium'] ?>);">
			               <a href="<?php echo $color['color_image']['url'] ?>" class="nivo-lb">
			                   <i class="luxx-search"></i>
			               </a>
			           	</div>
			           	<div class="color-desc center-align">
			               <h6><?php echo $color['color_name'] ?></h6>
			               <h6><?php echo $color['color_code'] ?></h6>
			           	</div>
		       		</div>
		       	<?php endforeach ?>

		       	<!-- Pagination -->
		       	<div class="row">
		       		<div class="col s12">
			       		<?php
			       		// Pagination
			       	  	$paginate = paginate_links( array(
			       	    	'base' => get_permalink() . '%#%' . '/',
			       	    	'format' => '?page=%#%',
			       	    	'current' => $page,
			       	    	'total' => $pages,
			       	    	'prev_text' => '<i class="luxx-long-arrow-left"></i>',
			       	    	'next_text' => '<i class="luxx-long-arrow-right"></i>',
			       	    	'type' => 'array',
			       	  	));
			       	  	if (is_array($paginate)) {
	       	  	           	echo '<ul class="pagination center-align valign-wrapper" style="margin-top: 40px;">';
	       	  	           	foreach ($paginate as $page) {
	       	  	            	echo "<li>$page</li>";
	       	  	           	}
	       	  	          	echo '</ul>';
	       	  	       	}
			       		?>
			       	</div>
		       	</div>
	       	<?php endif ?>
		</div>
	</div>
</section>
<?php endwhile; ?>
<?php get_footer(); ?>
