<?php
/**
 * The template for displaying About
 *
 * Template Name: About
 *
 * @package Luxx
 */
get_header(); ?>
<?php while (have_posts()) : the_post(); ?>
	<section class="parallax-container valign-wrapper banner-single">
		<?php $img = get_field('banner'); ?>
		<?php if (isset($img['url'])): ?>
			<div class="parallax"><img src="<?php echo $img['url'] ?>"></div>
		<?php endif; ?>
	    <a id="scrollto" href="#"><i class="luxx-chevron-thin-down"></i></a>
	</section>
	<div class="image-credit" style="margin-left: 40px;">
		<p><?php echo get_featured_image_copyright($img['ID']) ?></p>
	</div>

	<section class="valign-wrapper">
	    <div class="container-50 valign center-align">
	        <div class="row">
	            <div class="col s12 l8 offset-l2">
	                <h2 class="title-2"><?php echo get_field('who_we_are_sub_title') ?></h2>
	                <h3 class="title-3"><?php echo get_field('who_we_are_title') ?></h3>
	                <?php echo get_field('who_we_are_text'); ?>
	                <p>
	                    <a href="<?php echo get_field('who_we_are_video'); ?>" class="btn nivo-lb-yt"><?php echo get_field('video_button_text') ?></a>
	                </p>
	            </div>
	        </div>
	    </div>
	</section>

	<section>
	    <div class="container-fluid">
	        <div class="row valign-wrapper">
	            <div class="col s12 m6 l5 offset-l1 valign">
	                <h3 class="title-3"><?php echo get_field('mission_title') ?></h3>
	                <p><?php echo get_field('mission_text') ?></p>
	                <br>
	                <br>
	                <h3 class="title-3"><?php echo get_field('expertise_title') ?></h3>
	                <p><?php echo get_field('expertise_text') ?></p>
	            </div>
	            <div class="col s12 m6 l5 offset-l1 valign no-pad">
					<?php $img2 = get_field('image'); ?>
					<?php if (isset($img2['url'])): ?>
						<img src="<?php echo $img2['url'] ?>" class="responsive-img full-width" alt="Image">
					<?php endif; ?>

					<div class="image-credit">
						<p>
							<?php echo get_featured_image_copyright($img2['ID']) ?>
						</p>
					</div>
	            </div>
	        </div>
	    </div>
	</section>

	<section class="parallax-container">
	    <div class="parallax">
			<?php $quote_image = get_field('quote_image'); ?>
			<?php if (isset($quote_image['url'])): ?>
				<img src="<?php echo $quote_image['url'] ?>">
			<?php endif; ?>
		</div>
	    <div class="container-50 center-align">
	        <div class="row">
	            <div class="col s12 l8 offset-l2">
	                <div class="quote" style="margin-top: 40px;"><?php echo get_field('quote_text') ?></div>
	                <br>
	                <br>
	                <br>
	                <h5 class="title-2" style="margin-bottom:0"><?php echo get_field('quote_author') ?></h5>
	                <p class="text-style-2" style="margin-top:0; line-height: 2em;"><?php echo get_field('author_job') ?></p>
	            </div>
	        </div>
	    </div>
	</section>
	<div class="image-credit" style="margin-left: 40px;">
		<p>
			<?php echo get_featured_image_copyright($quote_image['ID']) ?>
		</p>
	</div>

	<section>
	    <div class="container-50">
	        <div class="row center-align">
	            <div class="col s12 m6 about-slider-wrapper">
	                <h3 class="title-3"><?php echo get_field('value_title') ?></h3>
	                <p><?php echo get_field('value_text') ?></p>
	                <div id="value-carousel" class="owl-carousel accolade-carousel">
	                	<?php $values = get_field('values'); ?>
	                	<?php foreach ($values as $value): ?>
	                    <div style="width: 100%; margin-top: 95px;">
	                        <h4 class="title-3 valign center-align"><?php echo $value['value_content'] ?></h4>
	                    </div>
	                	<?php endforeach; ?>
	                </div>
	            </div>

	            <div class="col s12 m6 about-slider-wrapper">
	                <h3 class="title-3"><?php echo get_field('accolades_title') ?></h3>
	                <div id="accolade-carousel" class="owl-carousel accolade-carousel">
	                	<?php $accolades = get_field('accolades'); ?>
	                	<?php foreach ($accolades as $accolade): ?>
	                    <div class="item">
							<?php $logo = $accolade['logo']; ?>
							<?php if (isset($logo['url'])): ?>
							<div style="width: 100%; margin-top: 20px;">
								<img src="<?php echo $logo['url'] ?>" class="responsive-img" alt="Logo">
							</div>
							<?php endif ?>
	                        <div style="width: 100%; margin-top: 40px;">
	                            <p><?php echo $accolade['text'] ?></p>
	                        </div>
	                    </div>
	                	<?php endforeach; ?>
	                </div>
	            </div>
	        </div>
	    </div>
	</section>
<?php endwhile; ?>
<?php get_sidebar(); ?>
<?php get_footer(); ?>
