<?php
/**
 * The template for displaying Gallery
 *
 * Template Name: Gallery
 *
 * @package Luxx
 */

get_header(); ?>
<?php while (have_posts()) : the_post(); ?>
	<section>
	    <div class="container-50">
	        <div class="row" style="margin-bottom: 30px;">
	            <div class="col s12 select-box">
	                <h6 class="color-light"><?php echo get_field('select_category_caption') ?></h6>
	                <?php
	                // get list of products belong to this family
	                $args = array(
	                    'numberposts'   => -1,
	                    'post_type'     => 'photo-gallery',
	                    'order'         => 'ASC',
	                    'orderby'       => 'menu_order',
	                );
	                $query = new WP_Query($args);
	                $galleries = $query->get_posts();
	                ?>
	                <?php if (count($galleries) > 0): ?>
		                <a class="dropdown-button-click title-3" href="#!" data-activates="category_select"><span><?php echo get_field('gallery_name', $galleries[0]->ID) ?></span> <i class="luxx-chevron-down"></i></a>
		                <ul id="category_select" class="dropdown-content luxx_select">
		                	<?php foreach ($galleries as $gal): ?>
		                    <li><a href="#!" data-value="<?php echo get_field('gallery_name', $gal->ID) ?>" data-gallery="galleryPhoto-<?php echo $gal->ID ?>"><?php echo get_field('gallery_name', $gal->ID) ?></a></li>
		                	<?php endforeach ?>
		                </ul>
	            	<?php endif ?>
	            </div>
	        </div>

	        <?php foreach ($galleries as $key => $gal) { ?>
	        <div class="row gallery<?php echo ($key == 0) ? ' show' : '' ?>" id="galleryPhoto-<?php echo $gal->ID ?>">
	        	<div class="col s12 m8 l6 gallery-desc">
	                <?php echo get_field('gallery_description', $gal->ID) ?>
	            </div>
	            <br>
	            <br>
	            <div class="col s12">
	                <div class="gallery-slider-wrapper">
	                    <div id="gallery-carousel-<?php echo $key ?>" class="owl-carousel gallery-carousel">
                        	<?php
                        	$photos = get_field('photos_list', $gal->ID);
                        	if (count($photos) > 0) {
                        		foreach ($photos as $photo) { ?>
                        			<div class="item">
                        			<img src="<?php echo $photo['photo']['url'] ?>" class="responsive-img full-width">
                        			</div>
                        		<?php }
                        	} ?>
	                    </div>
	                </div>
	            </div>
	        </div>
	    	<?php } ?>

	</section>
<?php endwhile; ?>
<?php get_footer(); ?>
