<?php
/**
 * The template for displaying Color Chart
 *
 * Template Name: Color Chart
 *
 * @package Luxx
 */

get_header();

// pagination
if (get_query_var('page')) {
 	$page = get_query_var('page');
} else {
  	$page = 1;
}

$product_id = get_query_var('product-id', FALSE);
$category_id = get_query_var('category-id', FALSE);

if ($product_id) {
	// get list of color categories IDs
	$categories = get_field('color_categories', $product_id);
	$ids = wp_list_pluck( $categories, 'ID');

	// get colors
	$cat_list = [];
	if (count($ids > 0)) {
		if ($category_id) {
			$cat_list[] = get_post($category_id);
			$all_cat = FALSE;
		} else {
			// display all categories
			$cat_list = $categories;
			$all_cat = TRUE;
		}

		$total_colors = [];
		foreach ($cat_list as $cat) {
			$colors = get_field('colors', $cat->ID);
			foreach ($colors as $color) {
				$total_colors[] = $color;
			}
		}
	}
}

$page = get_page_by_path("color-chart");
$page_link = get_permalink($page->ID);

wp_reset_postdata();
?>
<?php while (have_posts()) : the_post(); ?>
<section>
   <div class="container-50">
       	<div class="row" style="margin-bottom: 30px;">
           <div class="col s12 m6 select-box">
               	<h6 class="color-light"><?php echo get_field('select_category_caption') ?></h6>
               	<?php if ($all_cat): ?>
               		<a class="dropdown-button-click title-3" href="#!" data-activates="category_select"><span><?php echo get_field('select_all') ?></span> <i class="luxx-chevron-down"></i></a>
               	<?php else: ?>
               		<a class="dropdown-button-click title-3" href="#!" data-activates="category_select"><span><?php echo $cat_list[0]->post_title ?></span> <i class="luxx-chevron-down"></i></a>
               	<?php endif ?>

               	<ul id="category_select" class="dropdown-content">
               		<?php $all_link = add_query_arg(array('product-id' => $product_id), $page_link);?>
               		<li><a href="<?php echo $all_link ?>"><?php echo get_field('select_all') ?></a></li>
               		<!-- Get all color categories for this product -->
               		<?php foreach ($categories as $cat): ?>
               			<?php $link = add_query_arg(array('product-id' => $product_id, 'category-id' => $cat->ID), $page_link);?>
                   		<li><a href="<?php echo $link ?>"><?php echo $cat->post_title ?></a></li>
                   	<?php endforeach ?>
               </ul>

           	</div>
           	<div class="col s12 m6">
           		<?php $specs = get_field('pdf_file', $product_id); ?>
               	<a target="_blank" href="<?php echo (isset($specs['url'])) ? $specs['url'] : '#' ?>" class="btn right"><?php echo get_field('product_specs_caption') ?></a>
           	</div>
       	</div>

       	<!-- displaying colors of current category -->
       	<div class="row category show">
			<?php
			// Variables
			$row              = 0;
			$color_per_page   = 8;
			$total            = count($total_colors);
			$pages            = ceil($total / $color_per_page);
			$min              = (($page * $color_per_page) - $color_per_page) + 1;
			$max              = ($min + $color_per_page) - 1;
			?>

	       	<?php if ($total > 0): ?>
	       		<?php foreach ($total_colors as $key => $color): ?>
	       			<?php
	       			$row++;  // Ignore this color if $row is lower than $min
    				if ($row < $min) { continue; }
    				// Stop loop completely if $row is higher than $max
    				if ($row > $max) { break; }
    				?>
		       		<div class="col s12 m3">
			           	<div class="color-box" style="background-image: url(<?php echo $color['color_image']['sizes']['medium'] ?>);">
			               <a href="<?php echo $color['color_image']['url'] ?>" class="nivo-lb">
			                   <i class="luxx-search"></i>
			               </a>
			           	</div>
			           	<div class="color-desc center-align">
			               <h6><?php echo $color['color_name'] ?></h6>
			               <h6><?php echo $color['color_code'] ?></h6>
			           	</div>
		       		</div>
		       	<?php endforeach ?>

		       	<!-- Pagination -->
		       	<div class="row">
		       		<div class="col s12">
		       			<ul class="pagination center-align valign-wrapper" style="margin-top: 40px;">
			       		<?php
			       		// Pagination
			       	  	$paginate = paginate_links( array(
			       	    	'base' => get_permalink() . '%#%' . '/',
			       	    	'format' => '?page=%#%',
			       	    	'current' => $page,
			       	    	'total' => $pages,
			       	    	'prev_text' => '<i class="luxx-long-arrow-left"></i>',
			       	    	'next_text' => '<i class="luxx-long-arrow-right"></i>',
			       	    	'type' => 'array',
			       	  	));
			       	  	if (is_array($paginate)) {
	       	  	           	echo '<ul class="pagination center-align valign-wrapper" style="margin-top: 40px;">';
	       	  	           	foreach ($paginate as $page) {
	       	  	            	echo "<li>$page</li>";
	       	  	           	}
	       	  	          	echo '</ul>';
	       	  	       	}
			       		?>
			       		</ul>
			       	</div>
		       	</div>
	       	<?php endif ?>
		</div>
	</div>
</section>
<?php endwhile; ?>
<?php get_footer(); ?>
