<?php
/**
 * The template for displaying Country Product
 *
 * Template Name: Country
 *
 * @package Luxx
 */

get_header(); ?>
<?php while (have_posts()) : the_post(); ?>
	<?php
	$products = get_field('products_list');
	?>
	<section style="padding: 0; margin-top: -40px;">
	    <div class="container-50">
	        <div class="row hide-on-small-only">
	            <div class="col s12">
	                <ul class="tabs brands-tabs">
	                	<?php if (count($products) > 0): ?>
	                		<?php foreach ($products as $key => $post): setup_postdata($post) ?>
	                    	<li class="tab col s12 m4">
	                    		<a class="<?php echo ($key == 0 ? 'active' : '') ?>" href="#" data-slide-index="<?php echo $key ?>">
	                    			<h4 class="title-3"><?php the_title() ?></h4><span><?php echo get_field('product_category') ?></span>
	                    		</a>
	                    	</li>
	                    	<?php endforeach ?>
	                	<?php endif ?>
	                </ul>
	            </div>
	        </div>
	        <div class="row hide-on-med-and-up" style="margin: 40px 0 30px;">
	            <div class="col s12 select-box">
	            	<?php if (count($products) > 0): ?>
	            		<a class="dropdown-button-click" href="#!" data-activates="category_select">
	            			<h4 class="title-3"><?php echo $products[0]->post_title ?></h4> <i class="luxx-chevron-down"></i><br><span><?php echo get_field('product_category', $products[0]->ID) ?></span>
	            		</a>
	            		<ul id="category_select" class="dropdown-content brands_select">
	                		<?php foreach ($products as $key => $post): setup_postdata($post) ?>
	                    		<li><a href="#!" data-value="<?php the_title() ?><" data-span="<?php echo get_field('product_category') ?>"
	                    		data-slide-index="<?php echo $key ?>"><?php the_title() ?></a></li>
	                    	<?php endforeach ?>
                    	</ul>
                	<?php endif ?>
	            </div>
	        </div>
	    </div>
	</section>

	<section style="padding-top: 0; overflow: hidden;">
	    <div class="container-50">
	        <div class="brands-slider-wrapper">
	            <div id="brands-carousel" class="owl-carousel brands-carousel">
	            	<?php if (count($products) > 0): ?>
	            		<?php foreach ($products as $key => $post): setup_postdata($post) ?>
		                <div class="item">
		                    <div class="row" style="margin-bottom: 40px">
		                        <div class="col s12">
		                            <img src="<?php echo get_field('product_image_1')['url'] ?>" class="responsive-img full-width">
		                        </div>
		                    </div>
		                    <div class="row valign-wrapper">
		                        <div class="col s12 m6 valign">
		                            <h3 class="title-3"><?php echo get_field('product_subtitle') ?></h3>
		                            <p><?php echo get_field('product_description') ?></p>

		                            <div class="row btn-list">
		                                <div class="col s12 l6">
		                                    <a href="#<?php echo $link ?>" class="btn btn-full"><?php echo get_field('product_button_1_caption') ?></a>
		                                </div>
		                                <div class="col s12 l6">
		                                	<?php
		                                	$page = get_page_by_path("color-chart");
		                                	$link = get_permalink($page->ID);
		                                	$link = add_query_arg(array('product_id' => $post->ID), $link);
		                                	?>
		                                    <a href="<?php echo $link ?>" class="btn btn-full"><?php echo get_field('product_button_2_caption') ?></a>
		                                </div>
		                            </div>
		                        </div>
		                        <div class="col s12 m6 valign">
		                            <img src="<?php echo get_field('product_image_2')['url'] ?>" class="responsive-img full-width" alt="Image">
		                        </div>
		                    </div>
		                </div>
	                	<?php endforeach ?>
	            	<?php endif ?>
	            </div>
	        </div>
	    </div>
	</section>
<?php endwhile; ?>
<?php get_footer(); ?>
