<?php
/**
 * The template for displaying Color Chart
 *
 * Template Name: Color Chart
 *
 * @package Luxx
 */

get_header();
$product_id = get_query_var('product_id', FALSE);
if ($product_id) {
	$colors = get_field('colors', $product_id);
}
wp_reset_postdata();
?>

<section>
   <div class="container-50">
       	<div class="row" style="margin-bottom: 30px;">
           <div class="col s12 m6 select-box">
               	<h6 class="color-light">Select Category</h6>
               	<a class="dropdown-button-click title-3" href="#!" data-activates="category_select"><span>View All</span> <i class="luxx-chevron-down"></i></a>
               	<ul id="category_select" class="dropdown-content luxx_select">
                   <li><a href="galaxy.html" data-value="Galaxy">Galaxy</a></li>
                   <li><a href="granite.html" data-value="Granite">Granite</a></li>
                   <li><a href="lucent.html" data-value="Lucent">Lucent</a></li>
                   <li><a href="marmo.html" data-value="Marmo">Marmo</a></li>
                   <li><a href="solid.html" data-value="Solid">Solid</a></li>
                   <li><a href="volcanics.html" data-value="Volcanics">Volcanics</a></li>
                   <li><a href="lg-hi-macs.html" data-value="View All">View All</a></li>
               </ul>
           	</div>
           	<div class="col s12 m6">
               <a href="#" class="btn right">Product Specifications</a>
           	</div>
       	</div>
       	<div class="row">
	       	<!--- Galaxy -->
	       	<?php if (count($colors) > 0): ?>
	       		<?php foreach ($colors as $color): setup_postdata($color) ?>
	       		<div class="col s12 m3">
		           	<div class="color-box" style="background-image: url(<?php echo get_field('color_image', $color->ID)['url'] ?>);">
		               <a href="<?php echo get_field('color_image', $color->ID)['url'] ?>" class="nivo-lb">
		                   <i class="luxx-search"></i>
		               </a>
		           	</div>
		           	<div class="color-desc center-align">
		               <h6><?php echo $color->post_title ?></h6>
		               <h6><?php echo get_field('color_code', $color->ID) ?></h6>
		           	</div>
		       	</div>
		       	<?php endforeach ?>
	       	<?php endif ?>
	   </div>

	   <!-- <div class="row">
	       <div class="col s12">
	           	<ul class="pagination center-align valign-wrapper" style="margin-top: 40px;">
	               <li class="disabled"><a href="#!"><i class="luxx-long-arrow-left"></i></a></li>
	               <li class="active"><a href="#!">1</a></li>
	               <li><a href="#!">2</a></li>
	               <li><a href="#!">3</a></li>
	               <li><a href="#!">4</a></li>
	               <li><a href="#!">5</a></li>
	               <li><a href="#!"><i class="luxx-long-arrow-right"></i></a></li>
	           	</ul>
	       	</div>
	   	</div> -->
	</div>
</section>

<?php get_footer(); ?>
