<?php
/**
 * The template for displaying About
 *
 * Template Name: About
 *
 * @package Luxx
 */
get_header(); ?>
<?php while (have_posts()) : the_post(); ?>
	<section class="parallax-container valign-wrapper banner-single">
	    <div class="parallax"><img src="<?php echo get_field('banner')['url'] ?>"></div>
	    <a id="scrollto" href="#"><i class="luxx-chevron-thin-down"></i></a>
	</section>

	<section class="valign-wrapper">
	    <div class="container-50 valign center-align">
	        <div class="row">
	            <div class="col s12 l8 offset-l2">
	                <h2 class="title-2">WHO WE ARE</h2>
	                <h3 class="title-3"><?php echo get_field('who_we_are_title') ?></h3>
	                <?php echo get_field('who_we_are_text'); ?>
	                <p>
	                    <a href="<?php echo get_field('who_we_are_video'); ?>" class="btn nivo-lb-yt">Watch Video</a>
	                </p>
	            </div>
	        </div>
	    </div>
	</section>

	<section>
	    <div class="container-fluid">
	        <div class="row valign-wrapper">
	            <div class="col s12 m6 l5 offset-l1 valign">
	                <h3 class="title-3"><?php echo get_field('mission_title') ?></h3>
	                <p><?php echo get_field('mission_text') ?></p>
	                <br>
	                <br>
	                <h3 class="title-3"><?php echo get_field('expertise_title') ?></h3>
	                <p><?php echo get_field('expertise_text') ?></p>
	            </div>
	            <div class="col s12 m6 l5 offset-l1 valign no-pad">
	                <img src="<?php echo get_field('image')['url'] ?>" class="responsive-img full-width" alt="Image">
	            </div>
	        </div>
	    </div>
	</section>

	<section class="parallax-container">
	    <div class="parallax" style="height: 50vh;"><img src="<?php echo get_field('quote_image')['url'] ?>" style="top: 0; bottom: auto;"></div>
	    <div class="container-50 center-align">
	        <div class="row">
	            <div class="col s12 l8 offset-l2">
	                <div class="quote"><?php echo get_field('quote_text') ?></div>
	                <br>
	                <br>
	                <br>
	                <h5 class="title-2" style="margin-bottom:0"><?php echo get_field('quote_author') ?></h5>
	                <p class="text-style-2" style="margin-top:0; line-height: 2em;"><?php echo get_field('author_job') ?></p>
	            </div>
	        </div>
	    </div>
	</section>

	<section>
	    <div class="container-50">
	        <div class="row center-align">
	            <div class="col s12 m6 about-slider-wrapper">
	                <h3 class="title-3"><?php echo get_field('value_title') ?></h3>
	                <p><?php echo get_field('value_text') ?></p>
	                <div id="value-carousel" class="owl-carousel value-carousel">
	                	<?php $values = get_field('values'); ?>
	                	<?php foreach ($values as $value): ?>
	                    <div class="item valign-wrapper">
	                        <h4 class="title-3 valign center-align"><?php echo $value['value_content'] ?></h4>
	                    </div>
	                	<?php endforeach; ?>
	                </div>
	                <div class="container-50 carousel-status value-carousel-status">
	                    <span class="owl-current"></span>of<span class="owl-total"></span>
	                </div>
	            </div>

	            <div class="col s12 m6 about-slider-wrapper">
	                <h3 class="title-3"><?php echo get_field('accolades_title') ?></h3>
	                <div id="accolade-carousel" class="owl-carousel accolade-carousel">
	                	<?php $accolades = get_field('accolades'); ?>
	                	<?php foreach ($accolades as $accolade): ?>
	                    <div class="item">
	                        <div style="width: 100%; margin-top: 20px;">
	                            <img src="<?php echo $accolade['logo']['url'] ?>" class="responsive-img" alt="Logo">
	                        </div>
	                        <div style="width: 100%; margin-top: 40px;">
	                            <p><?php echo $accolade['text'] ?></p>
	                        </div>
	                    </div>
	                	<?php endforeach; ?>
	                </div>
	            </div>
	        </div>
	    </div>
	</section>
<?php endwhile; ?>
<?php get_sidebar(); ?>
<?php get_footer(); ?>
