<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luxx
 */

?>

	</main><!-- #content -->
	<footer class="page-footer">
		<div class="footer-links-wrapper" style="background-image: url('<?php echo get_template_directory_uri() . '/img/footer-bg.png' ?>');">
		    <div class="container-50">
		        <div class="row">
		            <div class="col s12 l3">
		                <h3>Locate Us</h3>
		                <div class="social-links">
		                    <ul>
		                        <li>
		                            <a href="https://www.facebook.com/luxxnewhousegroup" target="_blank"><i class="luxx-facebook"></i></a>
		                        </li>
		                        <li>
		                            <a href="https://twitter.com/LuxxNewhouse" target="_blank"><i class="luxx-twitter"></i></a>
		                        </li>
		                        <li>
		                            <a href="https://plus.google.com/114757344405815377721/posts" target="_blank"><i class="luxx-google-plus"></i></a>
		                        </li>
		                        <li>
		                            <a href="http://luxx-newhouse-group.tumblr.com/" target="_blank"><i class="luxx-tumblr"></i></a>
		                        </li>
		                        <li>
		                            <a href="https://www.pinterest.com/luxxnewhouse/" target="_blank"><i class="luxx-pinterest"></i></a>
		                        </li>
		                    </ul>
		                </div>
		            </div>
		            <div class="col s12 l9">
		                <div class="row">
		                	<?php
		                	// get list of products belong to this family
		                	$args = array(
		                	    'numberposts'   => -1,
		                	    'post_type'     => 'contact-address',
		                	    'order'         => 'ASC',
		                	    'orderby'       => 'menu_order',
		                	);
		                	$query = new WP_Query($args);
		                	$products = $query->get_posts();
		                	?>
		                	<?php if (count($products) > 0): ?>
		                		<?php foreach ($products as $product): ?>
		                			<div class="col s12 m4 l4">
		                			    <h6 class="title-2"><?php echo $product->post_title ?></h6>
		                			    <p>
		                			     	<?php echo get_field('address', $product->ID); ?>
		                			     	<?php $latlng = get_field('map', $product->ID); ?>
		                			    	<a href="http://maps.google.com/maps?z=15&t=m&q=loc:<?php echo $latlng['lat'] ?>+<?php echo $latlng['lng'] ?>" class="georgia-link" target="_blank">View Map</a>
		                			    </p>
		                			    <br>
		                			    <p>
		                			    	<?php echo get_field('telephone', $product->ID); ?><br><?php echo get_field('fax', $product->ID); ?><br>
		                			        <a href="mailto:<?php echo get_field('email', $product->ID); ?>"><?php echo get_field('email', $product->ID); ?></a>
		                			    </p>
		                			</div>
		                		<?php endforeach ?>
		                	<?php endif ?>
		                </div>
		            </div>
		        </div>
		    </div>
		</div>

		<div class="footer-copyright">
		    <div class="container">
		        <div class="row valign-wrapper">
		            <div class="col s12 m5 offset-l1 right-align valign">
		                Living Aspirational Luxury
		            </div>
		            <div class="col s12 m2 l1 center-align valign hide-on-small-only">
		                <img src="<?php echo get_template_directory_uri() . '/img/logo.png' ?>" class="responsive-img" alt="LUXX">
		            </div>
		            <div class="col s12 m5 left-align valign">
		                &copy; LUXX Newhouse Group 2012-2015.
		            </div>
		        </div>
		    </div>
		    <a id="totop" class="btn-floating btn-totop hide-on-small-only"><i class="luxx-long-arrow-up"></i></a>
		</div>
	</footer>
</div><!-- #page -->

<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
<script>
    window.jQuery || document.write('<script src="<?php echo get_template_directory_uri() . '/js/vendor/jquery-1.11.3.min.js' ?>"><\/script>')
</script>
<?php wp_footer(); ?>

</body>
</html>
